/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {

        describe("Search Applet: Clinic List", function () {
            var view,
                viewEl,
                collection,
                model;

            beforeEach(function () {
                collection = new Backbone.Collection();
                model = new Backbone.Model({
                    patientFilter: "",
                    patientCollection: new Backbone.Collection(),
                    locationFilter: "",
                    locationCollection: collection
                });
                view = new Portal.ListGenerator.ClinicListView({
                    model: model,
                    collection: collection
                });
                viewEl = view.render().$el;
            });
            afterEach(function() {
                view.close();
                viewEl.remove();
            });

            it("shows a clinic in the list", function () {
                view.collection.add(new Portal.ListGenerator.Clinic({
                    name: "Radiation"
                }));
                
                var clinicEl = viewEl.find('ul li');
                
                expect(clinicEl.length).toEqual(1);
                expect(clinicEl.text()).toContain("Radiation");
            });
        });
    });